/**
* \file: hmi-error-codes.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: adit-application-framework
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#ifndef HMI_INTERFACES_INCLUDE_HMI_ERROR_CODES_H_
#define HMI_INTERFACES_INCLUDE_HMI_ERROR_CODES_H_

#ifdef __cplusplus
extern "C" {
#endif

/**
 * This enumeration defines error codes which might be exchanged between HMI and the application. They are transmitted
 * via dbus as an unsigned integer.
 */
typedef enum tb_hmi_error_codes_t
{
	/**
	 * No error
	 */
	TB_HMI_RESULT_OK					= 0,

	/**
	 * The application is unknown to the HMI
	 */
	TB_HMI_RESULT_APP_NOTKNOWN			= 1,

	/**
	 * The application is able to handle only one application at a time. An application gets this error code
	 * during registration if another application is registered with the HMI at this time.
	 */
	TB_HMI_RESULT_NO_MULTIPLE_APPS 		= 2,

	/**
	 * The application ran into resource issues while the application is registering.
	 */
	TB_HMI_RESULT_NO_RESOURCES			= 3,

        /**
         * The application is trying to register to D-Bus with an existing name
         */
        TB_HMI_RESULT_DUPLICATE_DBUS_NAME		= 4        
} tb_hmi_error_codes_t;

#ifdef __cplusplus
}
#endif

#endif /* HMI_INTERFACES_INCLUDE_HMI_ERROR_CODES_H_ */
